import type { NextApiRequest, NextApiResponse } from 'next'
import prisma from '../../../lib/db'
import { Zodiac } from '@prisma/client';

export default async function handler(req: NextApiRequest, res: NextApiResponse) {
  try {
    const zodiacs = await prisma.zodiac.findMany({
      include: {
        ZodiacSignWeekly: {
          where: {
            start_date: { lte: new Date() },
            end_date: { gte: new Date() }
          },
          orderBy: {
            start_date: 'desc'
          },
          take: 1
        }
      }
    })

    const currentDate = new Date();
    const currentYear = currentDate.getFullYear();
    // zodiacs.forEach(zodiac => {
    //   const startDate = new Date(`${currentYear}-${zodiac.start_date}`);
    //   const endDate = new Date(`${currentYear}-${zodiac.end_date}`);
    //   if (endDate < startDate) {
    //     endDate.setFullYear(currentYear + 1);
    //   }
    //   zodiac.selected = currentDate >= startDate && currentDate <= endDate;
    // });

    const formattedZodiacs = zodiacs.map(zodiac => {
      const startDate = new Date(`${currentYear}-${zodiac.start_date}`);
      const endDate = new Date(`${currentYear}-${zodiac.end_date}`);
      if (endDate < startDate) {
        endDate.setFullYear(currentYear + 1);
      }
      return {
        ...zodiac,
        selected: currentDate >= startDate && currentDate <= endDate,
        formatted_start_date: startDate.toLocaleDateString('en-US', { day: 'numeric', month: 'long' }),
        formatted_end_date: endDate.toLocaleDateString('en-US', { day: 'numeric', month: 'long' })
      };
    })

    res.status(200).json({"zodiacs" : formattedZodiacs})
  } catch (error) {
    console.error('Error fetching zodiac data:', error)
    res.status(500).json({ error: 'Failed to fetch zodiac signs and weekly data' })
  }
}