import type { NextApiRequest, NextApiResponse } from 'next'
import { generateWeeklyData } from '../../lib/generateWeeklyData'

export default async function handler(req: NextApiRequest, res: NextApiResponse) {
  if (req.method === 'GET') {
    try {
      await generateWeeklyData()
      res.status(200).json({ message: 'Weekly data generated successfully' })
    } catch (error) {
      console.error('Error generating weekly data:', error)
      res.status(500).json({ error: 'Failed to generate weekly data' })
    }
  } else {
    res.setHeader('Allow', ['POST'])
    res.status(405).end(`Method ${req.method} Not Allowed`)
  }
}